import { delay } from 'rxjs/operators';
import { Injectable } from '@angular/core';
import { environment } from '../../../../../environments/environment';
import { HttpClient } from '@angular/common/http';

@Injectable()
export class SavingCreateService {

  constructor(private httpClient: HttpClient) {
  }

  addSaving(saving) {
    return this.httpClient.post(
      `${environment.API_ENDPOINT}savings`,
      JSON.stringify(saving))
      .pipe(delay(environment.RESPONSE_DELAY));
  }
}
