import { delay } from 'rxjs/operators';
import { Injectable } from '@angular/core';
import { environment } from '../../../../../environments/environment';
import { HttpClient } from '@angular/common/http';

@Injectable()
export class LoanPurposeUpdateService {

  constructor(private httpClient: HttpClient) {
  }

  updateLoanPurpose(loanPurpose, id) {
    return this.httpClient.put(
      `${environment.API_ENDPOINT}loan-purposes/${id}`,
      JSON.stringify(loanPurpose))
      .pipe(delay(environment.RESPONSE_DELAY));
  }
}
