import { catchError, delay } from 'rxjs/operators';
import { Injectable } from '@angular/core';
import { environment } from '../../../../../environments/environment';
import { of as observableOf } from 'rxjs';
import { HttpClient, HttpErrorResponse } from '@angular/common/http';

@Injectable()
export class CreditLineCreateService {

  constructor(private httpClient: HttpClient) {
  }

  createCreditLine(data) {
    return this.httpClient.post(
      `${environment.API_ENDPOINT}credit-lines`,
      JSON.stringify(data))
      .pipe(delay(environment.RESPONSE_DELAY),
        catchError((err: HttpErrorResponse) => {
          const errObj = {
            error: true,
            message: err.error.message
          };
          return observableOf(errObj);
        }));
  }
}
